
function path = simmarkovinv(Q,T) ;

%%%
%%% simulation of Markov Chain with transition Q, for T period ; initial
%%% condition randomly picked from stationary distribution
%%% 

S = size(Q,1) ;

if size(Q,2)~=S
    disp('Q is not a square matrix');
end

%%% inv dis:
[eigenvectors,eigenvalues] = eig(Q') ;

x = find( abs(diag(eigenvalues)-1)<1e-13 ) ;

vector = eigenvectors(:,x) ;

path = zeros(T,1) ;

%%% Q'*vector = vector
%%% vector'*Q = vector' is an inv dis (normalized) ;

invdis = vector/sum(vector) ;

UU = rand(1) ;

[crap,path(1)] =  max( (cumsum(invdis)-UU>0) ) ;

U = rand(T-1,1) ;

for t=1:T-1
    [crap,path(t+1)] =  max( (cumsum(Q(path(t),:))-U(t)>0) ) ;
end

    
    